######################################################################################
#
#   HW Debugger for BW board bringup
#
#   author: Ananda (ANN)
#
######################################################################################

# imports
import serial
import msvcrt
import time
import argparse
import serial.tools.list_ports as list_ports
import os
import socket

from tftpy.TftpShared import SOCK_TIMEOUT

try:
    import tftpy
    firmwareUpdate = 1
except:
    print("tftpy not install. Firmware update not available")
    firmwareUpdate = 0

from bw_pack_request import pack_request

# Argument parser
parser = argparse.ArgumentParser(description='HW debug interface program')
parser.add_argument('--ip')
parser.add_argument('--flashtool')
parser.add_argument('--cmd')
args = parser.parse_args()

# Flash program binary
if( args.flashtool is not None):
    if( args.flashtool == "JLINK" ):
        print("------------------------------------")
        os.system("JLink -device STM32F767ZI -if SWD -speed 4000 commandFile.jlink")
        print("------------------------------------")
        time.sleep(0.1)
    elif( args.flashtool == "STLINK" ):
        print("------------------------------------")
        os.system("ST-LINK_CLI.exe -ME -P BW_CDA_Firmware.hex -V \"while_programming\" -Rst")
        print("------------------------------------")
        time.sleep(0.1)
    else:
        print("Argument must be STLINK or JLINK. Firmware file should be called BW_CDA_Firmware.hex")
        exit()

# Time related variables
start = 0
toggle_time = 1000
sleep_time = 0.001
cur_time = time.time()

request = args.cmd
print("cmd: {}".format(request))
request_items = args.cmd.rsplit()
print("request items!: {}".format(request_items))
        
# Open Socket and use that for communication
if( args.ip is not None ):
    # Open socket
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.settimeout(2)
        s.connect( (args.ip, 5000) )
    except:
        print("Opening socket failed. check ip: {}".format(args.ip))
        s.close()
        time.sleep(5)
        exit()

    s.settimeout(0.01)

    print("Connection open {}".format(s))

    print("------------------------------------")

    request_items = args.cmd.rsplit()
    print("Connection open {}".format(request_items))

    if (request_items[0] == 'FirmwareUpgrade' and len(request_items) == 2):
            if( firmwareUpdate == 0 ):
                    print("tftpy not installed. Cannot update over tftp")
            print("Starting firmware update over TFTP for " + request_items[1])
            client = tftpy.TftpClient(request_items[1], 69)
            client.upload('update.bin','BW_CDA_Firmware_crc.bin', timeout=10)
            print("Sending complete")
            time.sleep(1)
            request = 'Upgrade'
            command = pack_request( request )

            if command is not None:
                    print( "Sending: " + command )
                    s.send(command.encode())


    # Handle single commands
    else:
            print("send cmd: {}".format(request))

            command = pack_request( request )

            if command is not None:
                    print( "Sending: " + command )
                    s.send(command.encode())
    
    a = 100
    while( a ):
        try:
            msg = s.recv(100)
            try:
                print(msg.decode("Ascii"), end='')
            except:
                print("Unable to print. None-Ascii recieved")
        except:
            None
        a = a-1
        time.sleep(sleep_time)

    s.close()

time.sleep(3)
