import json
import re

# {"cmdSet": "", "cmdClass": "", "cmdFunc": "", "cmdTargetName":"", "cmdParameters": [] }}
# "cmdSet": ""
# "cmdClass": ""
# "cmdFunc": ""
# "cmdTargetName": ""
# "cmdParameters": []

def pack_request( request ):
    
    request_items = request.rsplit()
    try:
        # For sending the raw string (after 'Raw ') 
        if (request_items[0] == 'Raw'):
            return request[4:]

        elif( request_items[0] == 'Set' and len(request_items) == 3):
            cmdSet = 'LL'
            cmdClass = 'GPIO'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [int(request_items[2])]

        elif( request_items[0] == 'Get' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'GPIO'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'PWM' and len(request_items) == 3):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = 'Set'
            cmdTargetName = request_items[1]
            cmdParameters = [int(request_items[2])]

        elif( request_items[0] == 'LED' and len(request_items) == 3):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = 'Set'
            cmdTargetName = request_items[1]
            cmdParameters = [int(request_items[2])]

        elif( request_items[0] == 'LED' and len(request_items) == 5):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = request_items[1]
            cmdTargetName = request_items[1]
            cmdParameters = [int(request_items[2]), int(request_items[3]), int(request_items[4])]

        elif( request_items[0] == 'LED' and len(request_items) == 7):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = request_items[1]
            cmdTargetName = request_items[1]
            cmdParameters = [int(request_items[2]), int(request_items[3]), int(request_items[4]), int(request_items[5]), int(request_items[6])]

        elif( request_items[0] == 'LED' and request_items[1] == 'ID_mode' and len(request_items) == 3):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = request[1]
            cmdTargetName = ''
            cmdParameters = [int(request_items[2])]

        elif( request_items[0] == 'PHY' and len(request_items) == 3):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = request_items[1]
            cmdTargetName = "0"
            cmdParameters = [int(request_items[2])]

        elif( request_items[0] == 'PHY' and len(request_items) == 4):
            cmdSet = 'LL'
            cmdClass = request_items[0]
            cmdFunc = request_items[1]
            cmdTargetName = "0"
            cmdParameters = [int(request_items[2]), int(request_items[3])]

        elif( request_items[0] == 'REBOOT' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = 'Reboot'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'SendWOL' and len(request_items) == 7):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = 'SendWOL'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1], 16), int(request_items[2], 16), int(request_items[3], 16), int(request_items[4], 16), int(request_items[5], 16), int(request_items[6], 16)]


        elif( request_items[0] == 'SPDIFLevel' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = 'SPDIFLevel'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Alloc' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Upgrade' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'RestrictTFTP' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PrintStackInfo' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = []

        elif( request_items[0] == 'UnrestrictTFTP' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'Version' and (len(request_items) == 1 or len(request_items) == 2) ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            if( len(request_items) == 2 ):
                cmdParameters = [int(request_items[1])]
            else:    
                cmdParameters = [0]

        elif( request_items[0] == 'IP' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'TestEmail' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'Loopback_test' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'I2C_disconnect' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'ReadMacSerial' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'DeleteFiles' ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            if( len(request_items) == 2):
                cmdParameters = [int(request_items[1])]
            else:
                cmdParameters = []

        elif( request_items[0] == 'FixSerialNumber' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'TestGetSoftwareVersion' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'TestGetMacAddress' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'TestGetSerialNumber' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'ReconfigureDSP' ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            if( len(request_items) == 2 ):
                cmdParameters = [int(request_items[1])]
            else:
                cmdParameters = [1]

        elif( request_items[0] == 'TestSetDigitalConnections' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'TestSetAnalogConnections' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'TestSet12VTrigger' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpGet' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSetMode' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'StaticIpSetIp' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSetGateway' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSetMask' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSetPrimaryDns' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSetSecondaryDns' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpSave' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'StaticIpDelete' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'NET'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogGetLevel' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogSetLevel' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'LogRead' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogReadFirst' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogReadNext' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogClear' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'LogCheck' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'LOG'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'Write' and request_items[1] == 'I2C' and len(request_items) >= 5):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = 'CallI2CWrite'
            cmdTargetName = ''
            cmdParameters = [None]*(len(request_items)-2)
            for i in range(2, len(request_items)):
                cmdParameters[i-2] = int(request_items[i], 16)

        elif( request_items[0] == 'Read' and request_items[1] == 'I2C' and len(request_items) >= 4):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = 'CallI2CRead'
            cmdTargetName = ''
            if len(request_items) == 4:
                cmdParameters = [int(request_items[2], 16), int(request_items[3], 16)]
            else:
                cmdParameters = [int(request_items[2], 16), int(request_items[3], 16), int(request_items[4])]

        elif( request_items[0] == 'AnalogMode'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'DigitalMode'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'BurnInTestStart'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'BurnInTestCheck'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'RestartDSP'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'CheckSpdifSR'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'SetAmpTimeout'):
            cmdSet = 'LL'
            cmdClass = 'DSP'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            if len(request_items) == 2:
                cmdParameters = [int(request_items[1])]
            else:
                cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif( request_items[0] == 'Presets' and len(request_items) > 1):
            cmdSet = 'LL'
            cmdClass = 'Presets'
            cmdFunc = request_items[1]
            if len(request_items) > 2:
                cmdTargetName = request_items[2]
                cmdParameters = []
                for i in range(3,len(request_items)):
                    cmdParameters.append(int(request_items[i]))
            else:
                cmdTargetName = ''
                cmdParameters = []

        #---------- DSP API ---------------
        elif (request_items[0] == 'DSP_API_GetVersion'):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetVersion'
            cmdTargetName = ''
            cmdParameters = [0]

        elif (request_items[0] == 'DSP_API_SetInputSource' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetInputSource'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetInputSource' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetInputSource'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetInputMode' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetInputMode'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetInputMode' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetInputMode'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetDCEnable' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetDCEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetDCEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetDCEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetDCConfig' and len(request_items) == 8):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetDCConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4]), float(request_items[5]), float(request_items[6]), float(request_items[7])]

        elif (request_items[0] == 'DSP_API_GetDCConfig' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetDCConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetDCCoeffs' and len(request_items) == 7):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetDCCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2]), float(request_items[3]), float(request_items[4]), float(request_items[5]), float(request_items[6])]

        elif (request_items[0] == 'DSP_API_SetTrim' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetTrim'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetTrim' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetTrim'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetToneControlEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetToneControlEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_GetToneControlEnable' and len(request_items) == 1):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetToneControlEnable'
            cmdTargetName = ''
            cmdParameters = [0]

        elif (request_items[0] == 'DSP_API_SetChannelVolume' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetChannelVolume'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetChannelVolume' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetChannelVolume'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetMuteAll' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetMuteAll'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_GetMuteAll' and len(request_items) == 1):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetMuteAll'
            cmdTargetName = ''
            cmdParameters = [0]

        elif (request_items[0] == 'DSP_API_SetMuteChannel' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetMuteChannel'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetMuteChannel' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetMuteChannel'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetChannelPhase' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetChannelPhase'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetChannelPhase' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetChannelPhase'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetToneControlValue' and len(request_items) == 4):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetToneControlValue'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), float(request_items[3])]

        elif (request_items[0] == 'DSP_API_GetToneControlValue' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetToneControlValue'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_SetToneControlConfig' and len(request_items) == 8):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetToneControlConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4]), float(request_items[5]), float(request_items[6]), float(request_items[7])]

        elif (request_items[0] == 'DSP_API_GetToneControlConfig' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetToneControlConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetToneControlCoeffs' and len(request_items) == 7):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetToneControlCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2]), float(request_items[3]), float(request_items[4]), float(request_items[5]), float(request_items[6])]

        elif (request_items[0] == 'DSP_API_SetEQfilterEnable' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetEQfilterEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetEQfilterEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetEQfilterEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetEQfilterConfig' and len(request_items) == 9):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetEQfilterConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4]), int(request_items[5]), float(request_items[6]), float(request_items[7]), float(request_items[8])]

        elif (request_items[0] == 'DSP_API_GetEQfilterConfig' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetEQfilterConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_SetEQfilterCoeffs' and len(request_items) == 8):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetEQfilterCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), float(request_items[3]), float(request_items[4]), float(request_items[5]), float(request_items[6]), float(request_items[7])]

        elif (request_items[0] == 'DSP_API_GetEQfilterCoeffs' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetEQfilterCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_SetChannelDelay' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetChannelDelay'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2])]

        elif (request_items[0] == 'DSP_api_get_delay_ms' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetChannelDelay'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_GetOutputLevel' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetOutputLevel'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_GetInputLevel' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetInputLevel'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetXOfilterEnable' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetXOfilterEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetXOfilterEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetXOfilterConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetXOfilterConfig' and len(request_items) == 8):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetXOfilterConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4]), float(request_items[5]), float(request_items[6]), float(request_items[7])]

        elif (request_items[0] == 'DSP_API_GetXOfilterConfig' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetXOfilterConfig'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_SetXOfilterCoeffs' and len(request_items) == 8):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetXOfilterCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), float(request_items[3]), float(request_items[4]), float(request_items[5]), float(request_items[6]), float(request_items[7])]

        elif (request_items[0] == 'DSP_API_GetPostGain' and len(request_items) == 1):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetPostGain'
            cmdTargetName = ''
            cmdParameters = [0]

        elif (request_items[0] == 'DSP_API_SetPostGain' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetPostGain'
            cmdTargetName = ''
            cmdParameters = [float(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetDeqEnable' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetDeqEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetDeqEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetDeqEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetDeqID' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetDeqCoeffs'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_SetCompressor' and len(request_items) == 5):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetCompressor'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2]), float(request_items[3]), float(request_items[4])]

        elif (request_items[0] == 'DSP_API_SetCompressorEnable' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetCompressorEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetCompressorEnable' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetCompressorEnable'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetTestSignalGen' and len(request_items) == 5):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetTestSignalGen'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4])]

        elif (request_items[0] == 'DSP_API_GetTestSignalGen' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetTestSignalGen'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetSourcePriority' and len(request_items) == 5):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetSourcePriority'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2]), int(request_items[3]), int(request_items[4])]

        elif (request_items[0] == 'DSP_API_GetSourcePriority' and len(request_items) == 2):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetSourcePriority'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif (request_items[0] == 'DSP_API_SetSecondarySrcPresence' and len(request_items) == 4):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetSecondarySrcPresence'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), float(request_items[2]), float(request_items[3])]

        elif (request_items[0] == 'DSP_API_SetNoiseGate' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetNoiseGate'
            cmdTargetName = ''
            cmdParameters = [float(request_items[1]), float(request_items[2])]

        elif (request_items[0] == 'DSP_API_GetClippingFlags' and len(request_items) == 1):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'GetClippingFlags'
            cmdTargetName = ''
            cmdParameters = [0]

        elif (request_items[0] == 'DSP_API_SetMovieMode' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'SetMovieMode'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        elif (request_items[0] == 'DSP_API_Set9VrmsLPF' and len(request_items) == 3):
            cmdSet = 'DSP-API'
            cmdClass = 'DSP-API'
            cmdFunc = 'Set9VrmsLPF'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1]), int(request_items[2])]

        #-------------------------

        elif( request_items[0] == 'Power_On' or request_items[0] == 'Power_Off' or request_items[0] == 'SaveConfig'):
            cmdSet = 'LL'
            cmdClass = 'SYSTEM'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU'
            cmdParameters = [0]

        elif( request_items[0] == 'Zone1_temp'):
            cmdSet = 'LL'
            cmdClass = 'AMP'
            cmdFunc = 'Get_temp'
            cmdTargetName = 'Analog_Temp'
            cmdParameters = [1]

        elif( request_items[0] == 'Zone2_temp'):
            cmdSet = 'LL'
            cmdClass = 'AMP'
            cmdFunc = 'Get_temp'
            cmdTargetName = 'Analog_Temp'
            cmdParameters = [2]

        elif( request_items[0] == 'Fan_Control' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'FAN'
            cmdFunc = 'Fan_Control'
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PSU_temp'):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = 'Get_temp'
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [0]

        elif( request_items[0] == 'Standby_Mode' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Standby_WOL_Enable' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Standby_Timeout' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Standby_Delay' and len(request_items) == 2):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'Standby_Get' and len(request_items) == 1):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = 'PSU_NTC'
            cmdParameters = [0]
        
        elif( request_items[0] == 'EnterStandby' ):
            cmdSet = 'LL'
            cmdClass = 'PSU'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            if len(request_items) == 1:
                cmdParameters = [0]
            else:
                cmdParameters = [ int(request_items[1] ) ]

        elif( request_items[0] == 'FPGA' and (len(request_items) == 3 or len(request_items) == 4) ):
            cmdSet = 'LL'
            cmdClass = 'FPGA'
            cmdFunc = request_items[1]
            cmdTargetName = 'FPGA'
            cmdParameters = [int(request_items[2], 16), int(request_items[3])]

        #---------- PRODUCTION TESTING API ---------------
        elif( request_items[0] == 'PT_ListCommands' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_RunProdTest' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_ReadAtePin' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSoftwareVersion' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadMacAddress' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_WriteMacAddress' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'PT_OtpOverwriteMacAddress' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSerialNumber' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_WriteSerialNumber' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = request_items[1]
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadHwPins' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_VerifyReadFromFlash' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadDcProtect' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadAuxBrownout' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_Read12VTrigger' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSignalSenseZ1' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSignalSenseZ2' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSpdifSignalSense1' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadSpdifSignalSense2' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_PhyReset' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_CodecReset' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_DspReset' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_RgmiiPullupEnable' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_BuffersEnable' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_Fpga_1V0' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_Fpga_1V8' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_Psu_3V3' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_Codec_3V3' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_Dsp_1V2' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_ReadPhyStatusRegister' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadCodecStatusRegister' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadDspStatusRegister' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ProgramFpga' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_VerifyFpga' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ProgramDsp' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_VerifyDsp' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ProgramCodec' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_VerifyCodec' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ProgramCodec' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_GetSpdifReceiver' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ConfigVersaClock' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_VerifyVersaClock' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_PhyConfigure' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadIpAddress' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadClearWol' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_SetInputAnalog' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_SetInputSpdif' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadPsuTemp' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadPsuPrimaryTemp' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadPsuSecondaryTemp' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadAnalogTempZ1' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadAnalogTempZ2' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_EnableSignalSense' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_OverloadZ1' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_OverloadZ2' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ZoneMute1Pin' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_ZoneMute2Pin' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_ReadBtlZ1Pin' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadBtlZ2Pin' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_LedBusPin' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_FanPwmPin' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_SupplyStandbyPin' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_SupplyGood' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadClip1' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadClip2' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadClip3' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadClip4' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ClearButtonCounter' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadButtonCounter' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ClearResetCounter' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_ReadResetCounter' and len(request_items) == 1 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [0]

        elif( request_items[0] == 'PT_KillSignal' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_DacCalibrationCh1' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_DacCalibrationCh2' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_DacCalibrationCh3' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_DacCalibrationCh4' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_AdcCalibrationCh1' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_AdcCalibrationCh2' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_AdcCalibrationCh3' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        elif( request_items[0] == 'PT_AdcCalibrationCh4' and len(request_items) == 2 ):
            cmdSet = 'LL'
            cmdClass = 'PROD'
            cmdFunc = request_items[0]
            cmdTargetName = ''
            cmdParameters = [int(request_items[1])]

        #-------------------------

        else:
            cmdSet = 'Unknown'
            cmdClass = ''
            cmdFunc = ''
            cmdTargetName = ''
            cmdParameters = [0]
            print("-------------------------------------")
            print("Command unknown to Python. Please check command:\n{}".format(request))
            print("-------------------------------------")

        json_msg = json.dumps( {"cmdSet": cmdSet, "cmdClass": cmdClass, "cmdFunc": cmdFunc, "cmdTargetName": cmdTargetName, "cmdParameters": cmdParameters} )

    except Exception as e:
        print("Error in creating JSON. Invalid parameter given")
        print(e)
        json_msg = "Error"

    return json_msg
