def pack_request( request ):
    
    request_items = request.rsplit()
    
    # Handle commands and package in JSON

    # Set command to raw json input
    if (request_items[0] == 'Raw'):
        command = request[4:]
    # REBOOT [delay]
    elif (request_items[0] == 'REBOOT') and (len(request_items) == 2):
        command = "{\"" + request_items[0] + "\": " + request_items[1] + "}"
    
    # Get [GPIO]
    elif (request_items[0] == 'Get') and len(request_items) == 2:
        command = "{\"" + request_items[0] + "\": [\"" + request_items[1] + "\"] }"

    # Set/func [GPIO] [Value] 
    elif (request_items[0] == 'Set') and (len(request_items) == 3):
        command = "{\"" + request_items[0] + "\": { \"" + request_items[1] + "\": " + request_items[2] + "} }"
    elif (request_items[0] == 'Setfunc') and (len(request_items) == 3):
        command = "{\"" + request_items[0] + "\": { \"" + request_items[1] + "\": " + request_items[2] + "} }"

    # PWM [PWm_GPIO] [duty_cycle]
    elif (request_items[0] == 'PWM') and (len(request_items) == 3):
        command = "{\"" + request_items[0] + "\": { \"" + request_items[1] + "\": " + request_items[2] + "} }"

    # Function [Name]
    elif (request_items[0] == 'Function') and len(request_items) == 2:
        command = "{\"" + request_items[0] + "\": [\"" + request_items[1] + "\"] }"

    # Read I2C [dev] [add]
    elif (request_items[0] == 'Read') and len(request_items) == 4:
        command = "{\"" + request_items[0] + "\": {\"" + request_items[1] + "\": [" + str(int(request_items[2],0)) + ", " + str(int(request_items[3],0)) + "] } }"
        print("Not sent: " + command)
        command = None

    # Write I2C [dev] [add] [value]
    elif (request_items[0] == 'Write') and len(request_items) == 5:
        command = "{\"" + request_items[0] + "\": {\"" + request_items[1] + "\": [" + str(int(request_items[2],0)) + ", " + str(int(request_items[3],0)) + ", " + str(int(request_items[4],0)) + "] } }"
        print("Not sent: " + command)
        command = None

    # Read FPGA/MDIO [add]
    elif (request_items[0] == 'Read') and len(request_items) == 3:
        command = "{\"" + request_items[0] + "\": {\"" + request_items[1] + "\": " + str(int(request_items[2],0)) + "} }"
        print("Not sent: " + command)
        command = None

    # Write FPGA/MDIO [add] [value]
    elif (request_items[0] == 'Write') and len(request_items) == 4:
        command = "{\"" + request_items[0] + "\": {\"" + request_items[1] + "\": [" + str(int(request_items[2],0)) + ", " + str(int(request_items[3],0)) + "] } }"
        print("Not sent: " + command)
        command = None

    else:
        print("Unknown command structure")
        command = None

    return command
